function beverton_holt()
    % Configurazione
    x0 = 500;
    r = 1.0; % r deve essere nell'intervallo [1.0, 2.0]
             % Per r  1.5 la popolazione resta costante
             % Per r < 1.5 la popolazione cala (anche drasticamente)
             % Per r > 1.5 la popolazione si stabilizza
    k = 1000;
    
    % Simulazione
    T = 1:100;
    xc = x0;
    for t = T
        x(t) = xc;
        xc = f(xc, r, k);
    end
    
    % Disegno l'andamento nel tempo
    plot(T, x);
end

function xf = f(xc, r, k)
    xf = r * xc / (1 + xc/k);
end
